//
//  OPDocumentDataB5Operation.h
//  ApplicationFrameworks
//
//  Created by Nathan Van Fleet on 2015-07-13.
//
//

#import <Foundation/Foundation.h>
#import "OPDataMonitorProtocol.h"

@class B5Document;
@class B5Profile;
@class OPItem;

@interface B5DocumentDataOperation : NSObject

+ (BOOL)fileExistsOnDiskForDocument:(B5Document *)document;
+ (BOOL)decryptedFileExistsOnDiskForDocument:(B5Document *)document;
+ (BOOL)removeLocalCopyOnDiskOfDocument:(B5Document *)document error:(NSError **)error;
+ (NSString *)monitorIdentifierForDownloadOperationOfDocument:(B5Document *)document;
+ (NSString *)monitorIdentifierForUploadOperationOfDocument:(B5Document *)document;
+ (NSString *)monitorIdentifierForCreateOperationOfSourceFileURL:(NSURL *)sourceFileURL;

// Returns a file URL for a unencrypted file copy of the document. Will download the document file if not present on disk
+ (id <OPDataOperationMonitor>)dataOperationDownloadDocument:(B5Document *)document progressBlock:(void(^)(float percentage, NSUInteger activeStep, NSUInteger stepCount))progressBlock completion:(void(^)(NSURL *documentURL, NSError *error))completionBlock;

// Takes the file at the fileURL and creates a document without upload. Uploading can be done seperately or allowed to happen later (see below).
+ (id <OPDataOperationMonitor>)dataOperationCreateDocumentFromFileAtURL:(NSURL *)sourceFileURL profile:(B5Profile *)profile referencingItem:(OPItem *)referencingItem progressBlock:(void(^)(float percentage, NSUInteger activeStep, NSUInteger stepCount))progressBlock completion:(void(^)(B5Document *document, NSError *error))completionBlock;

@end
